% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_diagonal_matrix.R
\name{rand_diag_mat}
\alias{rand_diag_mat}
\title{Simulate a random diagonal variance matrix}
\usage{
rand_diag_mat(n = 5, min.var = 0, max.var = 1)
}
\arguments{
\item{n}{A scalar defining the dimensions of the variance matrix.}

\item{min.var}{A scalar defining the minimum variance.}

\item{max.var}{A scalar defining the maximum variance. \cr
\strong{Note:} \code{0 < min.var < max.var}.}
}
\value{
A diagonal \code{n x n} variance matrix.
}
\description{
Creates a diagonal \code{n x n} variance matrix with user-defined minimum and maximum
variances based on a continuous uniform distribution.
}
\examples{
# Simulate a random diagonal matrix with 10 columns and rows.
diag_mat <- rand_diag_mat(
  n = 10,
  min.var = 0,
  max.var = 0.2
)

}
