% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soft.thresholding.R
\name{soft.thresholding}
\alias{soft.thresholding}
\title{Soft-Thresholding Opreator on Covariance Matrix}
\usage{
soft.thresholding(sigma, threshold = 0.5)
}
\arguments{
\item{sigma}{a covariance matrix}

\item{threshold}{soft-thresholding parameter}
}
\value{
a regularized covariance matrix after soft-thresholding operation
}
\description{
Apply soft-thresholding operator on a covariance matrix with 
a soft-thresholding parameter.
}
\examples{
data(m.excess.c10sp9003)
cov.SAM <- cov(m.excess.c10sp9003)
soft.thresholding(cov.SAM, threshold = 0.001)
}
\references{
"High-Dimensional Covariance Estimation" by Mohsen Pourahmadi
}

