% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDinterfaces.R
\name{FD.density}
\alias{FD.density}
\title{The Flexible Dirichlet Density Function}
\usage{
FD.density(x, a, p, t)
}
\arguments{
\item{x}{vector of a point on the simplex. It must sum to one.}

\item{a}{vector of the non-negative alpha parameters.}

\item{p}{vector of the clusters' probabilities. It must sum to one.}

\item{t}{non-negative scalar tau parameter.}
}
\description{
Density function on the simplex for the Flexible Dirichlet distribution with parameters \code{a}, \code{p} and \code{t}.
}
\details{
Vectors \code{x}, \code{a} and \code{p} must be of the same length.
}
\examples{
x <- c(0.1,0.25,0.65)
alpha <- c(12,7,15)
prob <- c(0.3,0.4,0.3)
tau <- 8
FD.density(x,alpha,prob,tau)

}
\references{
{
 Ongaro, A. and Migliorati, S. (2013) A generalization of the Dirichlet distribution. Journal of Multivariate Analysis, \bold{114}, 412--426.\cr
\cr
 Migliorati, S., Ongaro, A. and Monti, G. S. (2016) A structured Dirichlet mixture model for compositional data: inferential and applicative issues. Statistics and Computing, doi:10.1007/s11222-016-9665-y.
}
}
\seealso{
\code{\link{FD.theorcontours}}, \code{\link{FD.generate}}
}
