% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculatePairwiseSimilarities.R
\name{calculatePairwiseSimilarities}
\alias{calculatePairwiseSimilarities}
\title{Run plink to Calculate Pairwise Similarities}
\usage{
calculatePairwiseSimilarities(
  file,
  db = NA,
  map = NA,
  out = NA,
  sexing = TRUE,
  verbose = TRUE,
  verbosity = 1
)
}
\arguments{
\item{file}{A string representing the path to the filtered ped/map file pair (without ped/map file extension).}

\item{db}{A string representing the path to an existing genotype database. If not provided, the function will proceed with the existing data.}

\item{map}{A string representing the filepath to PlateDnoY.map file. If not provided, the function will use the map file with the same name as the ped file.}

\item{out}{A string representing the path to the output. If not provided, the output will be written to a file with the same name as the input file, appended with "_oDB".}

\item{sexing}{A logical value indicating whether the function should try to perform sexing. Default is FALSE.}

\item{verbose}{A logical value indicating whether the output should be verbose. Default is TRUE.}

\item{verbosity}{An integer representing the level of verbosity. Set to a higher number for more detailed output. Default is 1.}
}
\value{
A list containing the following elements:
gensim, a matrix indicating if genotypes are called correctly for replicates and/or if genotypes are missing
summs, a matrix with summary statistics
}
\description{
This function serves as a wrapper to the 'PLINK' software, which is a free, open-source whole genome association analysis toolset.
It specifically uses 'PLINK' to calculate pairwise similarities between genotypes.
}
\details{
The function first checks the input parameters and sets default values if necessary. It then constructs and executes a PLINK command to merge
the genotype output with the existing genotype database if one is provided. Finally, it calculates pairwise similarities for all samples (and
database individuals) using another PLINK command. If the 'sexing' parameter is set to TRUE, the function will also attempt to determine the
sex of the individuals.
}
\examples{
\dontrun{

  outdir <- tempdir()

  calculatePairwiseSimilarities(file=file.path(outdir, "example_data.csv.GOOD"))
}

}
\references{
\itemize{
\item{Purcell S, Neale B, Todd-Brown K, Thomas L, Ferreira MAR, Bender D, Maller J, Sklar P, de Bakker PIW, Daly MJ & Sham PC (2007)
\emph{PLINK: a toolset for whole-genome association and population-based linkage analysis.} American Journal of Human Genetics, 81.}
\item{Purcell, Shaun. PLINK. \url{https://zzz.bwh.harvard.edu/plink/}}}
}
