% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topdown.R
\name{cttd}
\alias{cttd}
\title{Cross-temporal top-down reconciliation}
\usage{
cttd(base, agg_mat, agg_order, weights, tew = "sum", normalize = TRUE)
}
\arguments{
\item{base}{A (\eqn{hm \times 1}) numeric vector containing top- and \eqn{m} temporal
aggregated level base forecasts; \eqn{m} is the max aggregation order, and \eqn{h} is
the forecast horizon for the lowest frequency time series.}

\item{agg_mat}{A (\eqn{n_a \times n_b}) numeric matrix representing the cross-sectional
aggregation matrix. It maps the \eqn{n_b} bottom-level (free)
variables into the \eqn{n_a} upper (constrained) variables.}

\item{agg_order}{Highest available sampling frequency per seasonal cycle (max. order
of temporal aggregation, \eqn{m}), or a vector representing a subset of \eqn{p} factors
of \eqn{m}.}

\item{weights}{A (\eqn{n_b \times hm}) numeric matrix containing the proportions for each
high-frequency bottom time series; \eqn{n_b} is the total number of high-frequency
bottom variables, \eqn{m} is the max aggregation order, and \eqn{h} is the forecast horizon
for the lowest frequency time series.}

\item{tew}{A string specifying the type of temporal aggregation. Options include:
"\code{sum}" (simple summation, \emph{default}), "\code{avg}" (average),
"\code{first}" (first value of the period), and "\code{last}"
(last value of the period).}

\item{normalize}{If \code{TRUE} (\emph{default}), the \code{weights} will sum to 1.}
}
\value{
A (\eqn{n \times h(k^\ast+m)}) numeric matrix of cross-temporal reconciled forecasts.
}
\description{
Top-down forecast reconciliation for cross-temporal hierarchical/grouped
time series, where the forecast of a `Total' (top-level series, expected
to be positive) is disaggregated according to a proportional scheme (weights).
Besides fulfilling any aggregation constraint, the top-down reconciled
forecasts should respect two main properties:
\itemize{
\item the top-level value remains unchanged;
\item all the bottom time series reconciled forecasts are non-negative.
}
}
\examples{
set.seed(123)
# (3 x 1) top base forecasts vector (simulated), forecast horizon = 3
topf <- rnorm(3, 10)
A <- t(c(1,1)) # Aggregation matrix for Z = X + Y

# Same weights for different forecast horizons, agg_order = 4
fix_weights <- matrix(runif(4*2), 2, 4)
reco <- cttd(base = topf, agg_mat = A, agg_order = 4, weights = fix_weights)

# Different weights for different forecast horizons
h_weights <- matrix(runif(4*2*3), 2, 3*4)
recoh <- cttd(base = topf, agg_mat = A, agg_order = 4, weights = h_weights)

}
\seealso{
Top-down reconciliation: 
\code{\link{cstd}()},
\code{\link{tetd}()}

Cross-temporal framework: 
\code{\link{ctboot}()},
\code{\link{ctbu}()},
\code{\link{ctcov}()},
\code{\link{ctlcc}()},
\code{\link{ctmo}()},
\code{\link{ctrec}()},
\code{\link{cttools}()},
\code{\link{iterec}()},
\code{\link{tcsrec}()}
}
\concept{Framework: cross-temporal}
\concept{Reco: top-down}
