% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\name{SmokeH_df}
\alias{SmokeH_df}
\title{Smoking and Homocysteine Data}
\format{
A data frame with 2,475 observations and 15 variables:
\describe{
  \item{SEQN}{Participant identifier (integer)}
  \item{homocysteine}{Homocysteine level (numeric)}
  \item{z}{Z score indicator (integer)}
  \item{female}{Sex indicator (integer, 1 = female, 0 = male)}
  \item{age}{Age in years (integer)}
  \item{education}{Education level (integer code)}
  \item{povertyr}{Poverty ratio (numeric)}
  \item{bmi}{Body mass index (numeric)}
  \item{cotinine}{Cotinine level (numeric)}
  \item{st}{Smoking type indicator (integer)}
  \item{stf}{Smoking type (character string)}
  \item{age3}{Age category (integer code)}
  \item{ed3}{Education category (integer code)}
  \item{bmi3}{BMI category (integer code)}
  \item{pov2}{Poverty category (logical)}
}
}
\source{
Data taken from the evident package version 1.0.4
}
\usage{
data(SmokeH_df)
}
\description{
This dataset, SmokeH_df, is a data frame containing information on smoking,
homocysteine levels, demographics, and socioeconomic indicators. The dataset
consists of 2,475 observations and 15 variables, including biomarkers,
smoking-related measures, age, education, and poverty ratio. Some observations
contain missing values.
}
\details{
The dataset name has been kept as 'SmokeH_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
ForCausality package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not
been modified in any way.
}
