% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForLion_GLM_Optimal.R
\name{ForLion_GLM_Optimal}
\alias{ForLion_GLM_Optimal}
\title{ForLion for generalized linear models}
\usage{
ForLion_GLM_Optimal(
  n.factor,
  factor.level,
  var_names = NULL,
  xlist_fix = NULL,
  hfunc,
  bvec,
  link,
  reltol = 1e-05,
  delta = 0,
  maxit = 100,
  random = FALSE,
  nram = 3,
  logscale = FALSE,
  rowmax = NULL,
  Xini = NULL
)
}
\arguments{
\item{n.factor}{vector of numbers of distinct levels, “0” indicating continuous factors that always come first, “2” or more for discrete factors, and “1” not allowed.}

\item{factor.level}{list of distinct factor levels, “(min, max)” for continuous factors that always come first, finite sets for discrete factors.}

\item{var_names}{Names for the design factors. Must have the same length asfactor.level. Defaults to "X1", "X2", ...}

\item{xlist_fix}{list of discrete factor experimental settings under consideration, default NULL indicating a list of all possible discrete factor experimental settings will be used.}

\item{hfunc}{function for generating the corresponding model matrix or predictor vector, given an experimental setting or design point.}

\item{bvec}{assumed parameter values of model parameters beta, same length of h(y)}

\item{link}{link function, default "logit", other links: "probit", "cloglog", "loglog", "cauchit", "log", "identity"}

\item{reltol}{the relative convergence tolerance, default value 1e-5}

\item{delta}{relative difference as merging threshold for the merging step, the distance of two points less than delta may be merged, default 0, can be different from delta0 for the initial design.}

\item{maxit}{the maximum number of iterations, default value 100}

\item{random}{TRUE or FALSE, if TRUE then the function will run lift-one with additional "nram" number of random approximate allocation, default to be FALSE}

\item{nram}{when random == TRUE, the function will run lift-one nram number of initial proportion p00, default is 3}

\item{logscale}{TRUE or FALSE, whether or not to run the lift-one step in log-scale, i.e., using liftoneDoptimal_log_GLM_func() or liftoneDoptimal_GLM_func().}

\item{rowmax}{maximum number of points in the initial design, default NULL indicates no restriction}

\item{Xini}{initial list of design points, default NULL indicating automatically generating an initial list of design points.}
}
\value{
m number of design points

x.factor matrix with rows indicating design point

p D-optimal approximate allocation

det Optimal determinant of Fisher information matrix

convergence TRUE or FALSE

min.diff the minimum Euclidean distance between design points

x.close  a pair of design points with minimum distance

itmax iteration of the algorithm
}
\description{
ForLion algorithm to find D-optimal design for GLM models with mixed factors, reference: Section 4 in Huang, Li, Mandal, Yang (2024).
Factors may include discrete factors with finite number of distinct levels and continuous factors with specified interval range (min, max), continuous factors, if any, must serve as main-effects only, allowing merging points that are close enough.
Continuous factors first then discrete factors, model parameters should in the same order of factors.
}
\examples{
#Example 3 in Huang, Li, Mandal, Yang (2024), electrostatic discharge experiment
hfunc.temp = function(y) {c(y,y[4]*y[5],1);};   # y -> h(y)=(y1,y2,y3,y4,y5,y4*y5,1)
n.factor.temp = c(0, 2, 2, 2, 2)  # 1 continuous factor with 4 discrete factors
factor.level.temp = list(c(25,45),c(-1,1),c(-1,1),c(-1,1),c(-1,1))
link.temp="logit"
b.temp = c(0.3197169,  1.9740922, -0.1191797, -0.2518067,  0.1970956,  0.3981632, -7.6648090)
ForLion_GLM_Optimal(n.factor=n.factor.temp, factor.level=factor.level.temp, xlist_fix=NULL,
hfunc=hfunc.temp, bvec=b.temp, link=link.temp, reltol=1e-2, delta=0.03, maxit=500,
random=FALSE,nram=3, logscale=TRUE)

}
