% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_stand_methods.R
\name{summary.fe_stand}
\alias{summary.fe_stand}
\title{Summary for an \strong{fe_stand} Object}
\usage{
\method{summary}{fe_stand}(object, ...)
}
\arguments{
\item{object}{an \code{fe_stand} object}

\item{...}{additional arguments, passed to \code{\link{stand_sums_static}}}
}
\value{
data.frame (tibble) resulting from applying the function
\code{\link{stand_sums_static}} to \code{object}
}
\description{
Compute an overview of basic stand level variables for an \code{fe_stand}
object
}
\details{
The summary calls the function \code{\link{stand_sums_static}} with its
default settings. The result is a data.frame (tibble) with species and year
wise stand sum values per ha and mean values. Stem numbers, basal areas,
quadratic mean diameters and dominant diameters (d 100) are always
calculated. Quadratic mean heights, dominant heights (h 100), and wood
volumes are only calculated if the heights of all trees are given in
\code{object} (i.e. no NA). The summary contains a column
\code{species_id}. Depending on the setting of
\code{options("fe_spec_lang")}, the species ids will be printed as the
species code (settings NULL or "ger"), scientific, English, or German species
names (settings "sci", "eng", or "ger", respectively).
}
\examples{

# Make a stand data.frame (or nicer, a tibble) that meets the minimum
# requirements for setting up a fe_Stand object
some_stand <- tibble::tibble(
  tree_id = as.character(c(1:100)),
  species_id = as_fe_species_tum_wwk_short(
    as.character(c(rep(1, 40), rep(5, 60)))
  ),
  time_yr = rep(2022, 100),
  dbh_cm = c(rnorm(40, 40.1, 7.3), rnorm(60, 32.8, 8.4)),
)

# Make the object
some_fe_stand <- fe_stand(
  some_stand,
  tree_id_col = "tree_id",
  species_id_col = "species_id",
  time_yr_col = "time_yr",
  dbh_cm_col = "dbh_cm",
  area_ha = 0.25
)

# The summary with different language choices
options(fe_spec_lang = "code")
summary(some_fe_stand)
options(fe_spec_lang = "sci")
summary(some_fe_stand)
options(fe_spec_lang = "eng")
summary(some_fe_stand)
options(fe_spec_lang = "ger")
summary(some_fe_stand)


# Use example stands
options(fe_spec_lang = "eng")
norway_spruce_1_fe_stand |> summary()
summary(european_beech_1_fe_stand)
options(fe_spec_lang = "sci")
summary(selection_forest_1_fe_stand)
spruce_beech_1_fe_stand |> summary()
options(fe_spec_lang = "code")
summary(selection_forest_1_fe_stand)
spruce_beech_1_fe_stand |> summary()

}
\seealso{
\link{stand_sums_static}
}
