% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fe_species_tum_wwk_long.R
\name{validate_fe_species_tum_wwk_long}
\alias{validate_fe_species_tum_wwk_long}
\title{Validate an \emph{fe_species_tum_wwk_long} Object}
\usage{
validate_fe_species_tum_wwk_long(x = character())
}
\arguments{
\item{x}{An object that is expected to be a correct
\code{fe_species_tum_wwk_long} object}
}
\value{
Returns \code{x}, but this function is mainly called for its side
effect which is pointing out any violations of the
\code{fe_species_tum_wwk_long} object specifications. In case of such
violations, the function will terminate with an error.
}
\description{
Regular users will not require this function. Expert users will want to use
it in combination with the constructor
\code{\link{new_fe_species_tum_wwk_long}}. Regular users, please construct
\code{fe_species_tum_wwk_long} objects with
\code{\link{fe_species_tum_wwk_long}}.
}
\examples{
# Passes validation
spec_ids <- as.character(c(70, 61, 88, 88, 10, 971, 32))
spec_ids <- new_fe_species_tum_wwk_long(spec_ids)
validate_fe_species_tum_wwk_long(spec_ids)

# Validating the following spec_ids throws an error due to
# non-supported species codes
spec_ids <- as.character(c(70, 61, 1221, 88, 88, 10, 971, 32, 4031))
spec_ids <- new_fe_species_tum_wwk_long(spec_ids)
try(
  validate_fe_species_tum_wwk_long(spec_ids)
)

}
