\name{fitJSB}
\alias{fitJSB}
\title{Estimating parameters of the Johnson's SB (JSB) distribution using four methods}
\description{Suppose \eqn{x=(x_1,\dots,x_n)^T} denotes a vector of \eqn{n} independent observations coming from a four-parameter JSB distribution with probability density function given given by
\deqn{
f\bigl(x\big|\Theta\bigr) = \frac {\delta \lambda}{\sqrt{2\pi}(x-\xi)(\lambda+\xi-x)}\exp\Biggl\{-\frac{1}{2}\Bigg[\gamma+\delta\log \biggl(\frac{x-\xi}{\lambda+\xi-x}\biggr) \Bigg]^2\Biggr\},
}
where \eqn{\xi<x<\lambda+\xi}, \eqn{\Theta=(\delta,\gamma,\lambda,\xi)^T} with \eqn{\delta, \lambda> 0}, \eqn{-\infty<\gamma<\infty}, and \eqn{-\infty<\xi<\infty}. Using Bayesian approach, method of conditional maximum likelihood (CML, Johnson (1949)), method of moment (MM, Fonseca(2009)), and two-percentile method that proposed by Knoebel and Burkhart (1991) (KB). We compute all four estimators when the scale \eqn{\lambda}, and location \eqn{\xi}, parameters are predetermined. The method proposed by Ogana (2018) has been used for predetermining the scale and location parameters. Let DBH accounts for diameter at breast height (DBH),  for estimating parameters \eqn{\delta} and \eqn{\gamma} through the Bayesian approach, the location and scale parameters are predetermined as \eqn{\xi = \min(DBH) - 1.34} and \eqn{\lambda = \max(DBH) - \xi + 3.8}, respectively. For the MM, CML, and KB methods, the parameters \eqn{\xi} and \eqn{\lambda} are predetermined in the same way as suggested by Ogana (2018).
determine
}
\usage{fitJSB(y, n.burn=8000, n.simul=10000)}
\arguments{
  \item{y}{Vector of DBH observations.}
  \item{n.burn}{Length of the burn-in period, i.e., the point after which Gibbs sampler is supposed to attain convergence. By default \code{n.burn} is 8000.}
  \item{n.simul}{Total numbers of Gibbs sampler iterations. By default \code{n.simul} is 10,000.}
}
\details{The Bayes' estimators are obtained by averaging on the all iterations between \code{n.burn} and \code{n.simul}.}
\value{A list of objects in two parts as
\enumerate{
\item Four estimators including Bayes, MM, CML, and KB.
\item A sequence of four goodness-of-fit measures consist of Anderson-Darling (\code{AD}), Cramer-von Mises (\code{CVM}), Kolmogorov-Smirnov (\code{KS}), and log-likelihood (\code{log-likelihood}) statistics.
}
}
\references{
N. L. Johnson, 1949. Systems of frequency curves generated by methods of translation, \emph{Biometrika}, 36, 149-176.

B . R. Knoebel and E. Burkhart, 1991. A bivariate distribution approach to modeling forest diameter distributions at two points in time, \emph{Biometrics}, 3, 241-253.

T. F. Fonseca, 2009. Describing maritime pine diameter distributions with Johnson's SB distribution using a new all-parameter recovery approach,
\emph{Forest Science}, 55, 367-373.

F. N. Ogana, 2018. Evaluation of four methods of fitting Johnson’s SBB for height and volume predictions, \emph{Journal of Forest Science}, 64, 187-197.
}

\examples{
# Here we use the SW dataset provided by FIA that represents a typical loblolly pine plantation.
# As the variable of interest, we fit the JSB distribution to the diameter at breast height (SW$DIA)
# in inches.
data(SW)
y <- SW$DIA
fitJSB(y, n.burn=8000, n.simul=10000)
}

