% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HMM_fit.R
\name{HMM.fit}
\alias{HMM.fit}
\title{Fitting for parsimonious hidden Markov models for four-way data}
\usage{
HMM.fit(
  X,
  k = 1:3,
  init.par = NULL,
  mod.row = "all",
  mod.col = "all",
  ncores = 1,
  verbose = FALSE,
  ret.all = FALSE
)
}
\arguments{
\item{X}{An array of dimension \code{p} x \code{r} x \code{n} x \code{t}, where \code{p} is the number of
variables in the rows of each data matrix, \code{r} is the number of variables in the columns of each
data matrix, \code{n} is the number of data observations and \code{t} is the number of times.}

\item{k}{An integer or a vector indicating the number of states of the models.}

\item{init.par}{The initial values for starting the algorithms, as produced by the \code{HMM.init()} function.}

\item{mod.row}{A character vector indicating the parsimonious structure of the row covariance matrix.
Possible values are: "EII", "VII", "EEI", "VEI", "EVI", "VVI", "EEE", "VEE", "EVE", "EEV", "VVE", "VEV",
"EVV", "VVV" or "all". When "all" is used, all of the 14 row parsimonious structures are considered.}

\item{mod.col}{A character vector indicating the parsimonious structure of the column covariance matrix.
Possible values are: "II", "EI", "VI", "EE", "VE", "EV", "VV", or "all". When "all" is used, all of
the 7 column parsimonious structures are considered.}

\item{ncores}{A positive integer indicating the number of cores used for running in parallel.}

\item{verbose}{A logical indicating whether the running output should be displayed.}

\item{ret.all}{A logical indicating whether to report the results of all the models or only those of the best
model according to the BIC.}
}
\value{
A list with the following elements:
\item{all.models}{The results related to the all the fitted models (only when \code{ret.all = TRUE}).}
\item{BicWin}{The best fitting model according to the BIC.}
\item{Summary}{A quick table showing summary results for the best fitting model according to the BIC.}
\item{c.time}{Provides information on the computational times required to fit all the models for each state.}
}
\description{
Fits, by using an ECM algorithm, parsimonious hidden Markov models to the given four-way data.
Parallel computing is implemented and highly recommended for a faster model fitting. The Bayesian
information criterion (BIC) is used to select the best fitting model.
}
\examples{
data(simX)

init <- HMM.init(X = simX, k = 2, nstartR = 1)
res <- HMM.fit(X = simX, k = 2, init.par = init, mod.row = "VII", mod.col = "EE")
}
