% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-expectedInterval.R
\docType{methods}
\name{expectedInterval}
\alias{expectedInterval}
\alias{expectedInterval,FuzzyNumber-method}
\alias{expectedInterval,TrapezoidalFuzzyNumber-method}
\alias{expectedInterval,PiecewiseLinearFuzzyNumber-method}
\alias{expectedInterval,PowerFuzzyNumber-method}
\title{Calculate the Expected Interval of a Fuzzy Number}
\usage{
\S4method{expectedInterval}{FuzzyNumber}(object, ...)

\S4method{expectedInterval}{TrapezoidalFuzzyNumber}(object)

\S4method{expectedInterval}{PiecewiseLinearFuzzyNumber}(object)

\S4method{expectedInterval}{PowerFuzzyNumber}(object)
}
\arguments{
\item{object}{a fuzzy number}

\item{...}{for \code{FuzzyNumber} and \code{DiscontinuousFuzzyNumber} - additional arguments passed to \code{\link{integrateAlpha}}}
}
\value{
Returns a numeric vector of length 2.
}
\description{
We have \eqn{EI(A) := [\int_0^1  A_L(\alpha)\,d\alpha,\int_0^1  A_U(\alpha)\,d\alpha]
}{EI(A) := [int_0^1  A_L(\alpha) d\alpha, int_0^1  A_U(\alpha) d\alpha]},
see (Duboid, Prade, 1987).
}
\details{
Note that if an instance of the \code{FuzzyNumber} or \code{DiscontinuousFuzzyNumber} class
is given, the calculation is performed via numerical integration.
Otherwise, the computation is exact.
}
\references{
Dubois D., Prade H. (1987), The mean value of a fuzzy number,
 Fuzzy Sets and Systems 24, pp. 279-300.
}
\seealso{
Other FuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{Extract}},
\code{\link{FuzzyNumber-class}},
\code{\link{FuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{alphacut}()},
\code{\link{ambiguity}()},
\code{\link{as.FuzzyNumber}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{core}()},
\code{\link{distance}()},
\code{\link{evaluate}()},
\code{\link{expectedValue}()},
\code{\link{integrateAlpha}()},
\code{\link{piecewiseLinearApproximation}()},
\code{\link{plot}()},
\code{\link{show}()},
\code{\link{supp}()},
\code{\link{trapezoidalApproximation}()},
\code{\link{value}()},
\code{\link{weightedExpectedValue}()},
\code{\link{width}()}

Other TrapezoidalFuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{TrapezoidalFuzzyNumber-class}},
\code{\link{TrapezoidalFuzzyNumber}},
\code{\link{TriangularFuzzyNumber}()},
\code{\link{alphaInterval}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{plot}()}

Other PiecewiseLinearFuzzyNumber-method: 
\code{\link{Arithmetic}},
\code{\link{Extract}},
\code{\link{PiecewiseLinearFuzzyNumber-class}},
\code{\link{PiecewiseLinearFuzzyNumber}},
\code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}},
\code{\link{alphaInterval}()},
\code{\link{arctan2}()},
\code{\link{as.PiecewiseLinearFuzzyNumber}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()},
\code{\link{fapply}()},
\code{\link{maximum}()},
\code{\link{minimum}()},
\code{\link{necessityExceedance}()},
\code{\link{necessityStrictExceedance}()},
\code{\link{necessityStrictUndervaluation}()},
\code{\link{necessityUndervaluation}()},
\code{\link{plot}()},
\code{\link{possibilityExceedance}()},
\code{\link{possibilityStrictExceedance}()},
\code{\link{possibilityStrictUndervaluation}()},
\code{\link{possibilityUndervaluation}()}

Other PowerFuzzyNumber-method: 
\code{\link{Extract}},
\code{\link{PowerFuzzyNumber-class}},
\code{\link{PowerFuzzyNumber}},
\code{\link{alphaInterval}()},
\code{\link{as.PowerFuzzyNumber}()},
\code{\link{as.TrapezoidalFuzzyNumber}()},
\code{\link{as.character}()}
}
\concept{FuzzyNumber-method}
\concept{PiecewiseLinearFuzzyNumber-method}
\concept{PowerFuzzyNumber-method}
\concept{TrapezoidalFuzzyNumber-method}
