% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C.test.R
\name{C.test}
\alias{C.test}
\title{Cochran's C test of homogeneity of variances}
\usage{
C.test(object)
}
\arguments{
\item{object}{an object of class "\code{\link{lm}}", containing the specified design.}
}
\value{
A list of class htest containing the following components:

\item{statistic}{Cochran's C test statistic}

\item{p-value}{The p-value of the test}

\item{alternative}{A character string describing the alternative hypothesis}

\item{method}{The character string Cochran test of homogeneity of variances}

\item{data.name}{A character string giving the name of the lm object}

\item{estimate}{Sample estimates of variances}
}
\description{
Performs a Cochran's test of the null hypothesis that the largest variance in several sampled variances are the same.
}
\details{
The test statistic is a ratio that relates the largest variance to the sum of the sampled variances.
}
\examples{
library(GAD)
data(rohlf95)
CG <- as.fixed(rohlf95$cages)
MQ <- as.random(rohlf95$mosquito)
model <- lm(wing ~ CG + MQ\%in\%CG, data = rohlf95)
C.test(model)
}
\seealso{
\code{\link{gad}}
}
\author{
Leonardo Sandrini-Neto (\email{leonardosandrini@ufpr.br})
}
