#' Function to estimate gene-level p-value using Davies algorithm
#'
#' @param marker_ld A symmetric squared matrix containing the pairwise linkage disequilibrium between markers in a chromosome
#' @param marker_pvalues A vector with the p-values for the SNPs annotated within each gene
#' @return A vector of p-values for each gene annotated within the defined coordinates
#' @importFrom Matrix sparseMatrix
#' @importFrom Matrix Diagonal
#' @importFrom CompQuadForm davies
#' @name Davies_ld
#' @keywords internal

Davies_ld<-function(matrix.ld,marker_pvalues){
  
  ###Getting eingenvalues from the correlation matrix
  eigen_res<-eigen(matrix.ld)$values
  
  out.davies<-CompQuadForm::davies(sum(qnorm(marker_pvalues)^2),eigen_res)$Qq
  
  return(out.davies)
  
}