#' @export
#' @keywords internal
GARCHX.default <- function(eps, X, order = c(1, 1), delta = 2, optim.method = "NR"){
  # Fit the model and returns all the p-values
  # Basically GARCHXselect but without selection and with returning all the p-values

  # Just one pass of estimate

  # Declaring initial values for paramters
  # d = number of exogenous covariates
  if (is.null(X))
    d = 0
  else
  {
    # Error check: checks if X is a matrix
    if (!is.matrix(X)){
      stop("X must be a matrix with number of rows equal to the length of eps")
    } # End if
    
    # Error check: checks if number of rows of X is equal to length of eps
    if(dim(X)[1] != (length(eps))){
      stop("Number of rows of matrix X must be the same as eps")
    } # End if

    d <- ncol(X)
  }
  r <- 10


  # Error check: checks of order is a vector of length 2 for p and q values
  if (!is.vector(order) || length(order) != 2){
    stop("order must be a vector of length 2 with entries determining the order of the GARCH model")
  } # End if

  # Error check: order is c(0, 0)
  if(order[2] < 0){
    stop("q must be a non negative integer")
  } # End if

  if(order[1] <= 0){
    stop("p must be greater than 0")
  } # End if

  # Create object of class GARCHX
  obj <- create_GARCHXobj(eps = eps, X = X, order = order, d = d, delta = delta,
                    r = r, alpha.level = NA, adjust.method = 'none')

  # Extract p and q from order
  p <- order[1]
  q <- order[2]


  # Estimate coefficients
  estimated_values <- estimate(obj, optim.method)

  # Extract all estimated coefficients
  estimated_coefs <- estimated_values$coef

  # Adjust and assign p-values
  #obj$p.values <- p.adjust(estimated_values$pval[(p+q+2):(1+p+q+d)], method = obj$adjust.method)

  # Assign coefficients
  obj$omega <- estimated_coefs[1]
  obj$alpha <- estimated_coefs[2:(p+1)]
  if (q > 0)
    obj$beta <- estimated_coefs[(p+2):(p+q+1)]
  if (d > 0)
    obj$pi <- estimated_coefs[(p+q+2):(1+p+q+d)]

  if (d > 0)
  {
    obj$selectedX_index <- 1:d # there is no covariate selection, this function is only estimation for all
    obj$p.values <- estimated_values$pval
  }

    # Assign estimated likelihood
  obj$Likelihood <- estimated_values$minimum

  # Return obj of GARCHX
  return(obj)
} # End GARCHX.default
