% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_GJRSK.R
\name{gjrsk_est}
\alias{gjrsk_est}
\title{This function estimates GJRSK model's parameters.}
\usage{
gjrsk_est(data)
}
\arguments{
\item{data}{vector time series data}
}
\value{
list of parameters,standard errors of parameters,t-statistics,the minimum value of log-likelihood,AIC and BIC.
}
\description{
This function estimates GJRSK model's parameters.
}
\examples{
  library(GARCHSK)
  #load data
  data(GBP)
  
  # Estimate the parameters of GJR-SK model
  gjrsk_GBP<-gjrsk_est(GBP[1:100])
  
  # Parameters
  gjrsk_GBP$params
}
