% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/changesupport.R
\name{changesupport}
\alias{changesupport}
\title{Change the support from \code{\link{lmgce}} object}
\usage{
changesupport(object, support, verbose = 0)
}
\arguments{
\item{object}{fitted \code{\link{lmgce}} object.}

\item{support}{One of c("min", "1se", "elbow") or a chosen support from
\code{object$support.ok}.}

\item{verbose}{An integer to control how verbose the output is. For a value
of 0 no messages or output are shown and for a value of 3 all messages
are shown. The default is \code{verbose = 0}.}
}
\value{
An \code{\link{lmgce}} object with the specified support spaces
}
\description{
Changes the support spaces of a \code{\link{lmgce}} object
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)

res_gce_package_change <- changesupport(res_gce_package, "min")

summary(res_gce_package)

summary(res_gce_package_change)

}

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
