% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neaggingclassfunctions.R
\name{coefficients.neagging}
\alias{coefficients.neagging}
\title{Extract \code{\link{neagging}} Coefficients}
\usage{
\method{coefficients}{neagging}(object, which = which.min(object$error)[[1]], ...)
}
\arguments{
\item{object}{Fitted \code{\link{neagging}} model object.}

\item{which}{Number of aggregated models. The coefficients returned are by
default the ones that produced the lowest in sample error.}

\item{...}{Additional arguments.}
}
\value{
Returns the coefficients from a \code{\link{neagging}} object
}
\description{
Extract coefficients from a \code{\link{neagging}} object
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)

res_neagging <- neagging(res_gce_package)
coefficients(res_neagging)
coefficients(res_neagging, which = ncol(res_neagging$matrix))
}

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
