% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmgceclassfunctions.R
\name{confint.lmgce}
\alias{confint.lmgce}
\title{Confidence Intervals for \code{\link{lmgce}} Model Parameters and
Normalized Entropy}
\usage{
\method{confint}{lmgce}(
  object,
  parm,
  level = 0.95,
  which = c("estimates", "NormEnt"),
  method = {
     if (which == "estimates") {
         c("z", "percentile", "basic")
    
    }
     else {
         c("percentile", "basic")
     }
 },
  boot.B = ifelse(object$boot.B == 0, 100, object$boot.B),
  boot.method = object$boot.method,
  ...
)
}
\arguments{
\item{object}{Fitted \code{\link{lmgce}} model object.}

\item{parm}{a specification of which parameters are to be given confidence
intervals, either a vector of numbers or a vector of names. If missing,
all parameters are considered.}

\item{level}{the confidence level required. The default is
\code{level = 0.95}.}

\item{which}{One of \code{c("estimates", "NormEnt")}. The default is
\code{which = "estimates"}.}

\item{method}{method used to compute the interval. One of
\code{c("z","percentile", "basic")}. The default is \code{method = "z"} and
is only valid for the parameters.}

\item{boot.B}{A single positive integer greater or equal to 10 for the number
of bootstrap replicates for the computation of the bootstrap confidence
interval(s), to be used when \code{method = c("percentile", "basic")} and
when \code{object} was created with \code{boot.B = 0}. The default is
\code{boot.B = 100} when the \code{object} has no previous sampling information
and \code{boot.B = object$boot.B} otherwise, which corresponds to
the \code{boot.B} given to \code{lmgce} when the \code{object} was created.}

\item{boot.method}{Method used for bootstrapping. One of
\code{c("residuals", "cases", "wild")} which corresponds to resampling on
residuals, on individual cases or on residuals multiplied by a N(0,1) variable,
respectively. The default is \code{boot.method = object$boot.method}.}

\item{...}{additional arguments.}
}
\value{
A matrix (or vector) with columns giving lower and upper confidence
limits for each parameter. These will be labelled as (1-level)/2 and
1 - (1-level)/2 in percentage (by default 2.5 percent and 97.5 percent).
}
\description{
Computes confidence intervals for one or more parameters or Normalized Entropy
in a \code{\link{lmgce}} fitted model.
}
\examples{
\donttest{
res_gce_package <-
  lmgce(y ~ .,
        data = dataGCE,
        boot.B = 50,
        seed = 230676)
}

confint(res_gce_package, method = "percentile")

confint(res_gce_package, which = "NormEnt", level = 0.99)

confint(res_gce_package, parm = c("X005"), level = 0.99)

}
\author{
Jorge Cabral, \email{jorgecabral@ua.pt}
}
