% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RealData_Spatialmod_Final_Model.R
\name{Realdata_Finalmodel}
\alias{Realdata_Finalmodel}
\title{This function is used to estimate model parameters}
\usage{
Realdata_Finalmodel(
  ITER,
  zz,
  lambda0,
  sigma0,
  Di,
  D,
  n,
  time,
  tau,
  lambda,
  alpha0,
  q1,
  q2,
  cov1,
  cov2,
  phi,
  delta0,
  Nlabel,
  npar,
  I
)
}
\arguments{
\item{ITER}{Number of iterations}

\item{zz}{Number of Regions}

\item{lambda0}{Spatial dependence}

\item{sigma0}{precision}

\item{Di}{Euclidean distance between susceptible individual and infectious individual}

\item{D}{Neighborhood structure}

\item{n}{total number of individuals}

\item{time}{time}

\item{tau}{tau}

\item{lambda}{lambda ###}

\item{alpha0}{intercept}

\item{q1}{Number of variables corresponding to individual level data}

\item{q2}{Number of variables corresponding to area level data}

\item{cov1}{Individual level covariates}

\item{cov2}{Area level covariates}

\item{phi}{Spatial random effects}

\item{delta0}{Spatial parameter}

\item{Nlabel}{Label for each sample from the area}

\item{npar}{number of parameters}

\item{I}{Identity matrix}
}
\value{
Numerical values for estimates
}
\description{
This function is used to estimate model parameters
}
\examples{
Realdata_Finalmodel(2,4,0.2,0.5,
matrix(runif(400,min = 4,max = 20),nrow=20, byrow = TRUE),
matrix(c(0,-1,0,-1,-1,0,-1,-1,0,-1,0,-1,-1,-1,-1,0),nrow=4,byrow=TRUE),20,10,
sample(c(0,1),replace = TRUE, size = 20),rep(3,20),0.4,6,5,
matrix(runif(120, 0, 1),nrow=20,byrow=TRUE),
matrix(runif(20, 0, 1),nrow=4,byrow=TRUE),runif(4,min = 0, max = 1),2,
rep(1:4,each=5),15,diag(4))

}
