% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEC_features.R
\name{LRT_eep}
\alias{LRT_eep}
\title{Likelihood Ratio Test (LRT) for the exponent parameter in EEP model.}
\usage{
LRT_eep(data, theta0, theta1, eta1)
}
\arguments{
\item{data}{Observations.}

\item{theta0}{The MLE of theta when eta = 1.}

\item{theta1}{The unrestricted MLE of theta.}

\item{eta1}{The unrestricted MLE of eta.}
}
\value{
This function returns the test statistic and the p-value of the LRT test
}
\description{
This function computes the test statistic and the p-value of LRT for the exponent parameter in EEP model.
}
\details{
LRT_eep
}
\examples{
sample1 = eep_sampling(200,eta = 1.1,theta = 6)
eta1 = mle_search_eep(data = sample1)$eta
theta1 = mle_search_eep(data = sample1)$theta
theta0 = mle_iter_eep(data = sample1,eta = 1)
LRT_eep(sample1,theta0,theta1,eta1)
}
