% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEEmediate.R
\name{GEEmediate}
\alias{GEEmediate}
\title{Mediation Analysis for Generalized Linear Models Using the Difference Method}
\usage{
GEEmediate(
  formula,
  exposure,
  mediator,
  df,
  family = gaussian,
  corstr = "independence",
  conf.level = 0.95,
  surv = F,
  pres = "sep",
  niealternative = "two-sided",
  ...
)
}
\arguments{
\item{formula}{A formula expression as for
other regression models, of the form response ~ predictors. See the documentation of \code{\link[stats]{lm}} and \code{\link[stats]{formula}} for details.
predictors should include exposure/treatment and mediator.}

\item{exposure}{The exposure (string).}

\item{mediator}{The mediator (string).}

\item{df}{A name of a data frame where all variables mentioned in formula are stored.}

\item{family}{A \code{family} object to be used in gee: a list of functions and expressions for defining link and variance functions
see the gee documentation. Default is gaussian. See also \code{\link[gee]{gee}} and \code{\link[stats]{glm}}.}

\item{corstr}{A working correlation structure. See \code{\link[gee]{gee}} and \code{\link[stats]{glm}}.}

\item{conf.level}{Confidence level for all confidence intervals (default 0.95)}

\item{surv}{Is the outcome survival (not supported)}

\item{pres}{Presentation of the coefficient tables. "tog" for a single table, "sep" for two separated tables.}

\item{niealternative}{Alternative hypothesis for testing that the nie=0. Either "two-sided" (default) or
"one-sided" for alternative nie>0.}

\item{...}{Further arguments for the \code{gee} call.}
}
\value{
The output contains the following components:
\item{call}{The call.}
\item{GEE.fit}{Results of fitting the GEE for the duplicated data.}
\item{nie}{The natural indirect effect estimate. NIE and NDE are reported on the coefficient scale}
\item{nie.pval}{P-value for tesing mediation using the NIE.}
\item{nde}{The natural direct effect estimate.}
\item{nie.ci}{Confidence interval in for the NIE in confidence level conf.level.}
\item{pm}{The mediation proportion estimate.}
\item{pm.pval}{P-value for tesing one-sided mediation using the mediation proportion.}
\item{pm.ci}{Confidence interval for the mediation proportion in confidence level conf.level.}
}
\description{
Estimation of natural direct and indirect effects for generalized linear models. The function utilizes a data-duplication algorithm to fit
marginal and conditional GLMs in a way that allow for consistent variance estimation. The function
produces point estimates, confidence intervals and p-values for the natural indirect effect and the mediation proportion
}
\examples{
\dontrun{
SimNormalData <- function(n,beta1.star = 1, p = 0.3, rho =0.4, inter =  0)
{
 beta2 <- (p/rho)*beta1.star
 beta1 <- (1-p)*beta1.star
 XM <- MASS::mvrnorm(n, mu = c(0,0), Sigma = matrix(c(1,rho,rho,1),2,2))
 X <- XM[,1]
 M <- XM[,2]
 beta <- c(inter, beta1, beta2)
 print(beta)
 Y <- cbind(rep(1,n),XM)\%*\%beta+rnorm(n,0,sd = 1)
 return(data.frame(X = X, M = M, Y = Y))
}
set.seed(314)
df <- SimNormalData(500)
GEEmediate(Y ~ X + M, exposure = "X", mediator = "M", df = df)
}


}
\references{
Nevo, Liao and Spiegelman, \emph{Estimation and infernece for the mediation proportion}, International Journal of Biostatistics (2017+)
}
