% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.PTReg.R
\name{coef.PTReg}
\alias{coef.PTReg}
\title{Extract coefficients from a "PTReg" object}
\usage{
\method{coef}{PTReg}(object, ...)
}
\arguments{
\item{object}{Fitted \code{"PTReg"} model object.}

\item{\dots}{Not used. Other arguments to get coefficients.}
}
\value{
The object returned depends on the \dots{} argument which is passed on to the \code{coef}
method for \code{PTReg} objects.
\item{intercept}{The intercept estimate.}
\item{alpha}{The matrix of the coefficients for main environmental effects.}
\item{beta}{The matrix of the regression coefficients for all main genetic effects (the first row) and interactions.}
}
\description{
This function extracts main effect and interaction coefficients from a PTReg model, using the
stored \code{"PTReg"} object.
}
\references{
Yaqing Xu, Mengyun Wu, Shuangge Ma, and Syed Ejaz Ahmed.
\emph{Robust gene-environment interaction analysis using penalized trimmed regression. Journal of
Statistical Computation and Simulation, 88(18):3502-3528, 2018.}
}
\seealso{
\code{PTReg}, and \code{predict} methods, and
\code{bic.PTReg}.
}
