% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_periods.R
\name{aggregate_events}
\alias{aggregate_events}
\alias{aggregateEvents}
\alias{aggregatePeriods}
\alias{createEventMapping}
\title{Aggregate Events}
\usage{
aggregate_events(
  time_series,
  measure = "AGSA",
  time = "timestamp",
  sample_frequency,
  events = NA,
  start_time = "start",
  end_time = "end",
  fun = mean
)

aggregateEvents(...)

aggregatePeriods(...)

createEventMapping(...)
}
\arguments{
\item{time_series}{Data frame to be aggregated.}

\item{measure}{Name of the measure columns to be included.}

\item{time}{Name of the time column.}

\item{sample_frequency}{Measurement frequency of data.}

\item{events}{Data frame containing the start and end index of each event.}

\item{start_time}{Name of the column in events containing the start index of the events.}

\item{end_time}{Name of the column in events containing the end index of the events.}

\item{fun}{Function to apply on aggregation, defaults to mean.}

\item{...}{Additional arguments passed to internal aggregation functions.}
}
\value{
Data frame of aggregated events.
}
\description{
Aggregate Events
}
\details{
Wrapper function that calls \code{aggregate_periods} for events (duration of variable length).
}
\examples{
timestamp <- c(
  1619424004, 1619424005, 1619424006, 1619424007,
  1619424008, 1619424009, 1619424010, 1619424011,
  1619424012, 1619424013, 1619424014, 1619424015
)
value <- c(
  0.729614366, 1.729115871, 0.804973546, 2.510181118,
  2.23764038, 0.613203747, 0.681953275, 0.089566943,
  0.021042388, 2.4780338, 2.437488989, 2.632635727
)
data <- data.frame(timestamp, value)
event_start <- c(1, 5, 10)
event_end <- c(4, 9, 12)
aggregated_events <- aggregate_events(data,
  events = data.frame(start = event_start, end = event_end),
  measure = "value",
  time = "timestamp",
  start_time = "start",
  end_time = "end",
  sample_frequency = 1,
  fun = sum
)
}
