% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MPI_calibrate.R
\name{apply_calibration}
\alias{apply_calibration}
\title{Apply Calibration}
\usage{
apply_calibration(sensor_data, cal_params, measurement_device, use_temp = TRUE)
}
\arguments{
\item{sensor_data}{Raw sensor-level data from a bin file in the form
(x, y, z, Light, Button, Temp).}

\item{cal_params}{Calibration parameters for acceleration and
light from MPI.}

\item{measurement_device}{Name of the measurement device used "GENEActiv 1.1"
or "GENEActiv 1.2".}

\item{use_temp}{Allows auto-calibration to be run with and without
temperature compensation.}
}
\value{
Data frame of calibrated sensor data.
}
\description{
Apply Calibration
}
\details{
Function to apply calibration to sensor-level data from a bin file.
}
\examples{
cal_params <- list(
  scale = c(1.015, 1.017, 1.027),
  offset = c(0.00128, 0.0383, 0.0138),
  temperature_offset = c(0, 0, 0),
  error = NA,
  light_denominator = 48,
  light_numerator = 911
)

rawdata <- data.frame(
  time = c(rep(1726650857, 5)),
  x = c(0.2421875, 0.24609375, 0.25390625, 0.24609375, 0.23828125),
  y = c(-0.04296875, -0.04687500, -0.03515625, -0.03125000, -0.04296875),
  z = c(-0.9453125, -0.9453125, -0.9531250, -0.9531250, -0.9609375),
  light = c(rep(22, 5)),
  button = c(rep(0, 5)),
  temp = c(rep(21.3, 5)),
  volts = c(rep(4.0896, 5))
)
calibrated <- apply_calibration(rawdata, cal_params, "GENEActiv 1.1")
}
