% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ratio_adjust.R
\name{ratio_adjust}
\alias{ratio_adjust}
\title{Ratio Adjustment}
\usage{
ratio_adjust(
  ratio,
  coef = 0.8,
  method = c("log", "left.linear", "trunc.log", "linear")
)
}
\arguments{
\item{ratio}{a numeric vector or a positive numeric n-by-m matrix.}

\item{coef}{a positive number, a positive numeric vector or a positive numeric n-by-m matrix.
The smaller this value, the closer the adjusted ratio will be to one.}

\item{method}{a character string specifying the adjustment method.}
}
\value{
A vector or a matrix with dimensions the same as the argument ratio.
}
\description{
Adjust ratios to new values.
}
\details{
For a positive ratio and the following methods, the return values are as follows:
\itemize{
\item log : coef * log(ratio) + 1, if ratio >= 1; 1 / (coef * log(1 / ratio) + 1), if ratio < 1.
\item left.linear : 1 / (coef * (1 / ratio - 1) + 1), if ratio >= 1; 1 + coef * (ratio - 1), if ratio < 1.
\item trunc.log : max(coef * log(ratio) + 1, 0).
\item linear : coef * (ratio - 1) + 1.
}
}
\examples{
ratio_adjust(10, 0.8)
ratio_adjust(0.1, 0.8)

x <- seq(0.01, 2, 0.01)
plot(x, x, type = "l")
lines(x, ratio_adjust(x, 0.8, method = "log"), col = "red")
lines(x, ratio_adjust(x, 0.8, method = "left.linear"), col = "blue")
lines(x, ratio_adjust(x, 0.8, method = "trunc.log"), col = "green")

X <- replicate(3, x)
Y <- ratio_adjust(X, c(0.8, 1, 1.2))
matplot(x, Y, type = "l")
}
