% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GGUM2004.R
\name{write.GGUM2004}
\alias{write.GGUM2004}
\title{Writes a command file for 'GGUM2004'}
\usage{
write.GGUM2004(
  I,
  C,
  cutoff = 2,
  model = "GGUM",
  cmd.file = "cmd",
  data.file = "data",
  data.dir = tempdir()
)
}
\arguments{
\item{I}{The number of items.}

\item{C}{\eqn{C} is the number of observable response categories minus 1
(i.e., the item scores will be in the set \eqn{\{0, 1, ..., C\}}{{0, 1,
..., C}}). It should either be a vector of \eqn{I} elements or a scalar. In
the latter case it is assumed that \eqn{C} applies to all items.}

\item{cutoff}{Either a number or a vector of \eqn{I} elements which defines 
the cutoff value. Default is 2.}

\item{model}{A string identifying the model. Possible values are "GUM" or 
"GGUM" (default).}

\item{cmd.file}{A character string defining the name to give to the command 
file. No file extension is required.}

\item{data.file}{A character string defining the name of the data file. No 
file extension is required.}

\item{data.dir}{A character string defining the path to the directory where 
the data file (possibly exported by function 
\code{\link[GGUM]{export.GGUM2004}}) is stored. This also determines the 
directory where the command file generated by this function will be exported 
to. By default a temporary directory is used, but the user can naturally 
specify a directory of her choice.}
}
\value{
A script file is saved in the directory where 'GGUM2004' is installed.
}
\description{
\code{write.GGUM2004} creates a 'GGUM2004' command file according 
  to the test characteristics. The file is saved in the 'GGUM2004' predefined 
  installation folder.
}
\section{Details}{
 This function prepares a 'GGUM2004' friendly command script,
  which may be used to run the 'GGUM2004' program (Roberts, Donoghue, &
  Laughlin, 2000; Roberts et al., 2006). 'GGUM2004' may be executed directly 
  or may be called from R, see \code{\link[GGUM]{run.GGUM2004}}.
  
  By default and for convenience, the command script is saved in the same 
  directory where the data file resides (\code{data.dir}). By experience, we 
  noticed that long directory paths (especially if spaces are included) make 
  'GGUM2004' fail to execute with error \code{file not found}. Therefore, a 
  good advice is to choose \code{data.dir} wisely (short paths, no spaces).
  
  Observe that this function is optimized for the Windows operating system 
  because 'GGUM2004' is a Windows program.
}

\examples{
I <- 6
C <- c(3, 3, 3, 5, 5, 5)
write.GGUM2004(I, C, model = "GGUM")

}
\references{
\insertRef{Robertsetal2000}{GGUM}

\insertRef{Robertsetal2006}{GGUM}
}
\author{
Sebastian Castro-Alvarez, \email{secastroal@gmail.com}
}
