% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_GHRformulas.R
\name{as_GHRformulas}
\alias{as_GHRformulas}
\title{Convert R-INLA Model Formulas into a GHRformulas Object}
\usage{
as_GHRformulas(formulas)
}
\arguments{
\item{formulas}{A character vector of model formulas formatted for R-INLA. Each formula must contain
a single \code{~} separating the outcome variable from the predictors. Formulas generated with
\code{\link{write_inla_formulas}} are compatible with this function.}
}
\value{
A structured list of class \code{GHRformulas} with the following components:
\describe{
\item{\code{formulas}}{A character vector of the original INLA-compatible model formulas.}
\item{\code{vars}}{A data frame where each row corresponds to a formula and each column to a covariate.
Entries indicate whether a covariate is included in the formula.}
\item{\code{re}}{A character vector listing the random effects specified across all formulas.}
\item{\code{outcome}}{A character string indicating the outcome variable (must be consistent across formulas).}
}
}
\description{
This function converts a character vector of suitable R-INLA formulas into a structured \code{GHRformulas} object.
The \code{GHRformulas} object contains the standardized information about the fixed effects, the random effects, and the outcome variable,
ensuring consistency across multiple models to be fitted using the \code{\link{fit_models}} function.
}
\details{
The \code{as_GHRformulas()} function parses each input formula to extract the outcome variable,
fixed effects (covariates), and random effects. The resulting \code{GHRformulas} object is designed to be used
with the \code{\link{fit_models}} function for model fitting with R-INLA.
}
\examples{
# Define formulas
formulas <- c(
"dengue_cases ~ 1 + f(month_id, model = 'rw1')", 
"dengue_cases ~ 1 + f(month_id, model = 'rw1') + tmin.l1") 

# Convert the formulas into a GHRformulas object
formulas <- as_GHRformulas(formulas)

# Inspect the structured GHRformulas object
print(formulas)
# Visualize output: GHRformulas object
class(formulas)
}
\seealso{
\code{\link{write_inla_formulas}} to generate R-INLA compatible input formulas
}
