% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_coef.R
\name{plot_coef_varying}
\alias{plot_coef_varying}
\title{Produce a Forest Plot for a Spatially or Temporally Varying Effects from a \code{GHRmodels} object.}
\usage{
plot_coef_varying(
  models,
  mod_id,
  name,
  unit_label = NULL,
  palette = "IDE2",
  title = NULL,
  xlab = "Effect size",
  ylab = NULL,
  exp = FALSE
)
}
\arguments{
\item{models}{A \code{GHRmodels} object containing fitted model output.}

\item{mod_id}{A character specifying which model to be plotted (as in \code{models$mod_gof$model_id}).}

\item{name}{A character string naming the spatially or temporally varying coefficient to plot.
This should match a random effect name in \code{models$random[[mod_id]]}.}

\item{unit_label}{Optional named character vector providing custom labels for each spatial/temporal unit.}

\item{palette}{Character string for the GHR, RColorBrewer or colorspace palette (e.g. "Purp") colour
palette to use for the different models. See all available options by running
\code{GHR_palettes()}, \code{RColorBrewer::display.brewer.all()} and
\code{colorspace::hcl_palettes(plot=TRUE)}. Single R colors in \code{colors()} or hex
codes can also be used.}

\item{title}{Optional string for the plot title.}

\item{xlab}{Optional character string for the x-axis label (default = "Effect size").}

\item{ylab}{Optional character string for the y-axis label (default constructed from varying covariate name).}

\item{exp}{Logical,if \code{TRUE} the coefficients are exponentiated, Default is if \code{FALSE}.}
}
\value{
A \code{ggplot2} forest plot object representing the spatially or temporally varying effect,
with each line corresponding to a different spatial or temporal unit.
}
\description{
Generates a forest plot for a specified spatially or temporally varying coefficient
(i.e. a random slope) from a fitted \code{GHRmodels} object. The plot displays the
effect estimates (x-axis) for each spatial/temporal unit (y-axis).
}
\examples{
\donttest{

# Load example GHRmodels object from the package: 
model_cov_list_file <- system.file("examples", "model_cov_list.rds", package = "GHRmodel")
model_cov_list <- readRDS(model_cov_list_file)

plot_coef_varying(
  models = model_cov_list,               # A list of fitted INLA model objects
  mod_id = "mod8",                       # Select the model with varying slopes
  palette = "Blues",                     # Color palette for the plot 
  name = "main_climate_f",               # The grouping variable 
  title = "Effect of PDSI at one-month lag for each climate zone",  # Plot title
  ylab = "Main climate zones",           # Label for the y-axis 
  unit_label = c(                        # Map factor levels to descriptive names 
    "1" = "Tropical Rainforest Climate", 
    "2" = "Tropical Monsoon Climate", 
    "3" = "Tropical Savanna Climate with Dry Winter",
    "4" = "Humid Subtropical Climate")
)
}

}
