% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAR.est.R
\name{MAR.est}
\alias{MAR.est}
\title{Missing At Random (MAR) proportion estimation based on technical replicates.}
\usage{
MAR.est(abundance, sample, log.scale = TRUE, violin.plot = FALSE)
}
\arguments{
\item{abundance}{The full abundance matrix without missing value, with features in rows and samples in columns.}

\item{sample}{A vector of characters or integers. It is the sample name for each pair of replicates.}

\item{log.scale}{A scalar or vector of proportions. It is the total percentage of missing peaks throughout the full matrix.}

\item{violin.plot}{Logical, whether to generate violin and box plots to visualize abundance distribution of missing and nonmissing peaks.}
}
\value{
\item{MAR.Proportion}{Estimated MAR proportion}
   \item{plot}{Violin and box plots generated by ggplot2}
}
\description{
MAR.est estimates the proportion of missing peaks at random (MAR) caused by preprocessing tools with exactly two technical replicates per sample.
}
\examples{
data('replicates')
# replicates contains mass specturm log abundance of 85 peptides
# with missing values for 4 pairs of technical replicates.


MAR=MAR.est(replicates,sample=rep(1:4,each=2),log.scale=FALSE,violin.plot=TRUE)
# Estimates the MAR proportion in the 4 pairs of replicates and output violin/box plots object.

print(MAR$plot)
# Print violin/box plots

}
