% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaSPUtils.R
\name{gp.predict}
\alias{gp.predict}
\title{Prediction at new inputs based on a Gaussian stochastic process model}
\usage{
gp.predict(obj, input.new, method = "Bayes")
}
\arguments{
\item{obj}{an \code{S4} object \linkS4class{gp}}

\item{input.new}{a matrix of new input lomessageions}

\item{method}{a string indicating the parameter estimation method:
\describe{
\item{MPLE}{This indicates that the \emph{maximum profile likelihood estimation} 
(\strong{MPLE}) is used. This correponds to simple kriging formulas}
\item{MMLE}{This indicates that the \emph{maximum marginal likelihood estimation} 
(\strong{MMLE}) is used. This corresponds to universal kriging formulas when the vairance
parameter is not integrated out. If the variance parameter is integrated out, 
the predictive variance differs from the universal kriging variance by the 
factor \eqn{\frac{n-q}{n-q-2}}, since the predictive distribution is a 
Student's \eqn{t}-distribution with degrees of freedom \eqn{n-q}.
 }
\item{MAP}{This indicates that the posterior estimates of model parameters are plugged into 
the posterior predictive distribution. Thus this approach does not take account into uncertainty 
in model parameters (\strong{range}, \strong{tail}, \strong{nu}, \strong{nugget}).}
\item{Bayes}{This indicates that a fully Bayesian approach is used
for parameter estimation (and hence prediction). This approach takes into account uncertainty in 
all model parameters.}
}}
}
\value{
a list of predictive mean, predictive standard deviation, 95\% predictive intervals
}
\description{
This function provides the capability to make prediction based on a GaSP
when different estimation methods are employed.
}
\examples{

 
code = function(x){
y = (sin(pi*x/5) + 0.2*cos(4*pi*x/5))*(x<=9.6) + (x/10-1)*(x>9.6) 
return(y)
}
n=100
input = seq(0, 20, length=n)
XX = seq(0, 20, length=99)
Ztrue = code(input)
set.seed(1234)
output = Ztrue + rnorm(length(Ztrue), sd=0.1)
obj = gp(formula=~1, output, input, 
        param=list(range=4, nugget=0.1,nu=2.5),
        smooth.est=FALSE,
        cov.model=list(family="matern", form="isotropic"))
 
fit.optim = gp.optim(obj, method="MMLE")
obj = fit.optim$obj
pred = gp.predict(obj, input.new=XX, method="MMLE")
                   
                   
                   
                   

}
\seealso{
\link{GPBayes-package}, \code{\link{GaSP}}, \linkS4class{gp}, \code{\link{gp.mcmc}}, \code{\link{gp.optim}}
}
\author{
Pulong Ma \email{mpulong@gmail.com}
}
