# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Calculate matrices for NSGP covariance function
#' @description Calculates matrices 'ScaleMat' and 'DistMat', which are used to 
#' obtain NSGP covariance matrices
#' @param A_List List of anisotropy matrices
#' @param coords Matrix of input coordinates (covariates)
#' 
#' @return A list of ScaleMat and DistMat matrices
#' 
#' @export
#' @examples
#' ## See examples in vignette:
#' # vignette("nsgpr", package = "GPFDA")
calcScaleDistMats <- function(A_List, coords) {
    .Call(`_GPFDA_calcScaleDistMats`, A_List, coords)
}

calcScaleDistMatsAsym <- function(A_List, Astar_List, coords, coordsStar) {
    .Call(`_GPFDA_calcScaleDistMatsAsym`, A_List, Astar_List, coords, coordsStar)
}

CovMaternCpp <- function(input, inputNew, cc, A, nu) {
    .Call(`_GPFDA_CovMaternCpp`, input, inputNew, cc, A, nu)
}

CovMaternCppSq <- function(input, cc, A, nu) {
    .Call(`_GPFDA_CovMaternCppSq`, input, cc, A, nu)
}

#' @title Calculate generalised distances
#' @description Calculate the generalised distance between vectors t and t'
#' using an anisotropy matrix A.
#' 
#' \itemize{
#' \item \code{distMat} and \code{distMatSq} calculate:
#' \deqn{ [(t - t')^{p/2}]^T A  (t - t')^{p/2}  }
#' \item \code{distMatLinear} and \code{distMatLinearSq} calculate:
#' \deqn{ t^T A t' }
#' }
#' 
#' 
#' @name distanceMatrix
#' @param input Vector of the input coordinate t
#' @param inputNew Vector of the input coordinate t'
#' @param A Anisotropy matrix A
#' @param power Power value p
#' @details The \code{distMatSq} and \code{distMatLinearSq} functions are 
#' used when input vectors t and t' are identical, returning a symmetric matrix. \cr \cr
#' When \code{distMat} and \code{distMatSq} functions are used in 
#' powered exponential kernels, power=1 gives the exponential kernel and 
#' power=2 gives the squared exponential one. \cr \cr
#' \code{distMatLinear} and \code{distMatLinearSq} functions are used in the 
#' linear covariance kernel.
#' @return A matrix
NULL

#' @rdname distanceMatrix
#' @export
distMat <- function(input, inputNew, A, power) {
    .Call(`_GPFDA_distMat`, input, inputNew, A, power)
}

#' @rdname distanceMatrix
#' @export
distMatSq <- function(input, A, power) {
    .Call(`_GPFDA_distMatSq`, input, A, power)
}

#' @rdname distanceMatrix
#' @export
distMatLinear <- function(input, inputNew, A) {
    .Call(`_GPFDA_distMatLinear`, input, inputNew, A)
}

#' @rdname distanceMatrix
#' @export
distMatLinearSq <- function(input, A) {
    .Call(`_GPFDA_distMatLinearSq`, input, A)
}

KCGP <- function(X, idx, va0s, va1s, A0s, A1s, sig) {
    .Call(`_GPFDA_KCGP`, X, idx, va0s, va1s, A0s, A1s, sig)
}

KCGPnm <- function(X, Xp, idx, idx_new, va0s, va1s, A0s, A1s, sig) {
    .Call(`_GPFDA_KCGPnm`, X, Xp, idx, idx_new, va0s, va1s, A0s, A1s, sig)
}

