% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRCdesigns.R
\name{SIGRC_I}
\alias{SIGRC_I}
\title{Structurally Incomplete Generalized Row Column Designs of Series-I}
\usage{
SIGRC_I(v)
}
\arguments{
\item{v}{Odd number(>3)}
}
\value{
This function generates structurally incomplete GRC designs for odd number of treatment with differential replication as well as the information matrix for estimating elementary treatment contrast.
}
\description{
The parameter of the design are v (odd), p = (v-1) rows of size 2(v-1) each, q = v columns [one column of size 2(v-1) and remaining of size 2(v- 2) each], k = 2, r_1 (replication of first v-1 treatments) = 2v-3 and r_2 (replication of the v th treatment) = v-1.
}
\examples{
library(GRCdesigns)
SIGRC_I(5)
}
\references{
1) Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2014). Structurally incomplete row-column designs with multiple units per cell. Statistics and Applications, 12(1&2), 71-79.

2)Datta, A., Jaggi, S., Varghese, C. and Varghese, E. (2015). Some series of row-column designs with multiple units per cell. Calcutta Statistical Association Bulletin, 67, ( 265-266), 89-99.

3)Datta, A., Jaggi, S., Varghese, C. and Varghese, E.  (2016). Series of incomplete row-column designs with two units per cell. Advances in Methodology and Statistics. 13(1), 17-25.
}
