% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_gridCopula.R
\name{estimate.gridCopula}
\alias{estimate.gridCopula}
\title{Estimates the parameters of a grid type copula}
\usage{
estimate.gridCopula(
  X = NULL,
  U = NULL,
  k = NULL,
  m = NULL,
  method = "ml",
  D.ini = NULL,
  criterion = "AIC"
)
}
\arguments{
\item{X}{a matrix of size \eqn{nx2} with the observed values in any domain, optional if \eqn{U} is provided.}

\item{U}{a matrix of size \eqn{nx2} with the observed values in the copula domain, optional if \eqn{X} is provided.}

\item{k}{a positive integer indicating the number of subintervals for the \eqn{U_2} variable.}

\item{m}{a positive integer indicating the number of subintervals for the \eqn{U_1} variable.}

\item{method}{The method selected for the estimation, can be least squares "ls"", maximum likelihood "ml" or penalized maximum likelihood "pml". By default "ml".}

\item{D.ini}{an optional matrix with initial density values for the estimation through maximum likelihood.}

\item{criterion}{If the values of k and m are not specified, they will be obtained by the "AIC" or "BIC" criteria, by default "AIC".}
}
\value{
Returns a list with a matrix with the density over the grid,
a matrix with the quantity of data over the grid, the number of subintervals for the \eqn{U_2} variable,
the number of subintervals for the \eqn{U_1} variable, a matrix with the values of \eqn{u_1} and \eqn{u_2} in the copula domain and a matrix with the original values X.
}
\description{
This function estimates grid type copulas by one of the following methods: maximum likelihood or least squares (See reference).
}
\examples{
# Generating simulated data with a transformation to the copula domain
n <- 500
x <- rgamma(n,4,1/2)
e <- rnorm(n,0,.3)
y <- sin(x+e)
Fx <- ecdf(x)
Fy <- ecdf(y)
u <- Fx(x)
v <- Fy(y)
df <- cbind(u,v)
copula.grid <- estimate.gridCopula(U = df, k = 5, m = 4 , method = "ml")
print(copula.grid$Density)

# Using the Iris dataset, transformation is not mandatory
copula.grid <- estimate.gridCopula(X = iris[,1:2], k = 3, m = 7 , method = "ml")
print(copula.grid$Density)
}
\references{
{
Pfeifer, D., Strassburger, D., & Philipps, J. (2020). 
Modelling and simulation of dependence structures in nonlife insurance with Bernstein copulas. 
\emph{arXiv}. Retrieved from \url{https://arxiv.org/abs/2010.15709}
}
}
