% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.R
\name{grnn}
\alias{grnn}
\title{General Regression Neural Networks (GRNNs)}
\usage{
grnn(p_input, p_train, v_train, fun = "euclidean", best.spread, scale = TRUE)
}
\arguments{
\item{p_input}{The dataframe of input predictors}

\item{p_train}{The dataframe of training predictor dataset}

\item{v_train}{The dataframe of training response variables}

\item{fun}{The distance function}

\item{best.spread}{The vector of best spreads}

\item{scale}{The logic statements (TRUE/FALSE)}
}
\value{
The predictions
}
\description{
This GRNNs uses various distance functions including: "euclidean", "minkowski",
"manhattan", "maximum", "canberra", "angular", "correlation", "absolute_correlation", "hamming",
"jaccard","bray", "kulczynski", "gower", "altGower", "morisita", "horn", "mountford", "raup",
"binomial", "chao", "cao","mahalanobis".
}
\examples{
data("met")
data("physg")
best.spread<-c(0.33,0.33,0.31,0.34,0.35,0.35,0.32,0.31,0.29,0.35,0.35)
predict<-physg[1,]
physg.train<-physg[-1,]
met.train<-met[-1,]
prediction<-grnn(predict,physg.train,met.train,fun="euclidean",best.spread,scale=TRUE)
}
