% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.kfold.R
\name{grnn.kfold}
\alias{grnn.kfold}
\title{General Regression Neural Networks (GRNNs)}
\usage{
grnn.kfold(x, y, k, fun, scale = TRUE)
}
\arguments{
\item{x}{The dataframe of training predictor dataset}

\item{y}{The dataframe of training response variables}

\item{k}{The numeric number of k folds}

\item{fun}{The distance function}

\item{scale}{The logic statements (TRUE/FALSE)}
}
\value{
rmse,stdae,stdev,mae,r,pvalue,best spread
}
\description{
General Regression Neural Networks (GRNNs)
}
\examples{
data("met")
data("physg")
\donttest{results_kfold<-grnn.kfold(physg,met,10,"euclidean",scale=TRUE)}
}
