% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{get_color_palette}
\alias{get_color_palette}
\title{Print and Visualize Themed Color Palettes}
\usage{
get_color_palette(color_tone = NULL, palette_type = "qualitative")
}
\arguments{
\item{color_tone}{Character. Name of the color theme to display
(e.g., `"gtap"`, `"winter"`, `"fall"`, or `"all"`).}

\item{palette_type}{Character. Palette type: `"qualitative"` (default), `"sequential"`, or `"diverging"`.}
}
\value{
A character vector of hex color codes representing the selected color palette.
If `color_tone = "all"`, returns a list of functions, each generating a specific palette.
If `color_tone = "list"`, returns a character vector of available palette names.
}
\description{
Prints and visualizes predefined color palettes used in GTAPViz.
Use `color_tone = "all"` to return a list of callable palette functions.
}
\examples{
# Get all palettes as callable functions
all_palettes <- get_color_palette("all")
all_palettes$winter()
all_palettes$gtap()

# Visualize specific palettes
get_color_palette("fall", "sequential")
get_color_palette("academic", "diverging")
}
\author{
Pattawee Puangchit
}
