% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylotree_class.R
\name{plot_proportions}
\alias{plot_proportions}
\title{Plot a phylogenetic tree with proportional node sizes and colors}
\usage{
plot_proportions(phylotree, proportions, labels = FALSE)
}
\arguments{
\item{phylotree}{A \code{Phylotree} class object representing the phylogenetic tree to be plotted.}

\item{proportions}{A numeric vector or matrix representing the proportions of each clone in the phylogenetic tree. If a matrix is provided, each row should represent the proportions for a separate tree.}

\item{labels}{A logical value indicating whether to label the nodes with gene tags (if \code{TRUE}) or gene indices (if \code{FALSE}). Default is \code{FALSE}.}
}
\value{
A graph representing the phylogenetic tree, with node sizes and colors reflecting clone proportions.
}
\description{
This function plots a phylogenetic tree with nodes sized and colored according to the proportions of each clone. If a matrix of proportions is provided, multiple phylogenetic trees will be plotted, each corresponding to a row of proportions.
}
\examples{
# Create an instance
# composed by 5 subpopulations of clones
# and 4 samples
instance <- create_instance(
       n = 5, 
       m = 4, 
       k = 1, 
       selection = "neutral")
       
# Extract its associated B matrix
B <- instance$B

# Create a new 'Phylotree' object
# on the basis of the B matrix
phylotree <- B_to_phylotree(B = B)

# Generate the tags for the genes of
# the phyogenetic tree
tags <- LETTERS[1:nrow(B)]

# Plot the phylogenetic tree taking
# into account the proportions of the
# previously generated instance
plot_proportions(phylotree, instance$U, labels=TRUE)
}
