% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_binom_baseline.R
\name{calculate_binom_baseline}
\alias{calculate_binom_baseline}
\title{Calculate binomials and significance for multiple baselines.}
\usage{
calculate_binom_baseline(data_df, baseline_female, confidence_level = 0.95)
}
\arguments{
\item{data_df, }{dataframe in output from \code{\link{reshape_for_binomials}}
containing the columns: female, male, which contain the integer counts of 
males and females respectively and must be a numeric vector greater than 0.}

\item{baseline_female, }{female baseline in percentage from \code{\link{baseline}}.}

\item{confidence_level, }{confidence level to use for significance calculation,
default is 0.95}
}
\value{
This function returns a dataframe with additional columns than the 
input one:

lower_CI = lower confidence level of confidence interval expressed as a 
percentage
      
upper_CI = upper confidence level of confidence interval expressed as a 
percentage
       
lower_CI_count = lower confidence level of confidence interval expressed as a
 count
       
upper_CI_count = upper confidence level of confidence interval expressed as a
 count
       
significance = flag indicating whether difference of female percentage with 
baseline percentage is significant for the row in consideration. It has
values "significant" or "" if not.
}
\description{
Function to calculate the lower CI, upper CI, percentages and 
counts, and significance of difference from one or multiple baseline 
percentages, given supplied confidence level using
}
