% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_for_binomials.R
\name{reshape_for_binomials}
\alias{reshape_for_binomials}
\title{Reshape the dataframe to make it easier to carry out binomial calculations.}
\usage{
reshape_for_binomials(data_df, gender_col, level)
}
\arguments{
\item{data_df, }{dataframe containing the columns gender and counts}

\item{gender_col, }{the name of the column containing the gender values.}

\item{level, }{variable to compare for the baseline.}
}
\value{
The output is a dataframe containing more columns than the input one,
such as:

level : the variable used to perform the binomials
total_for_level: the total amount of each gender including unknowns
total_female_male: the total amount of male and female
female_percentage: the percentage of female in the total_female_male
male_percentage: the percentage of male in the total_female_male
}
\description{
reshape dataframe from long format to wide format.
}
\examples{
authors_df <- assign_gender(data_df = authors, first_name_col = "first_name")
female_count <- dplyr::count(authors_df, gender)

## create a new data frame to be used for the binomial calculation.
df_gender <- reshape_for_binomials(data = female_count, gender_col = "gender",
                                  level = 2020)
}
