% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSTDist_FromMat.R
\name{MSTDist_FromMat}
\alias{MSTDist_FromMat}
\title{Calculates the minimum spanning tree distance, in kilometers, using Prim's Algorithm [1] and a previously calculated pairwsie distance matrix}
\usage{
MSTDist_FromMat(longs, lats, DistMat)
}
\arguments{
\item{longs}{- Longitudinal occurrences in decimal degrees}

\item{lats}{- Latitudinal occurrences in decimal degrees}

\item{DistMat}{- Pairwsie distance matrix of coordinates, from the PWMatrix() function}
}
\value{
Returns the minimum spanning tree distance in kilometers, the pairwise distance matrix of occurrences, the order points were connected in, and a 2-column array of coordinates
}
\description{
Calculates the minimum spanning tree distance, in kilometers, using Prim's Algorithm [1] and a previously calculated pairwsie distance matrix
}
\details{
Uses Prim's algorithm for finding the minimum spanning tree
}
\examples{
MSTCalc<-MSTDist(longs=c(22,44,-12,67),lats=c(-77,56,22,56))
MSTDist_FromMat(MSTCalc$Longitude,MSTCalc$Latitude,MSTCalc$MST_DistMat)
}
\references{
[1] Prim, R.C. 1957. Shortest Connection Networks and Some Generalizations. The Bell System Technical Journal 36:1389-1401.
}
