% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcd_hf.R
\name{gcd_hf}
\alias{gcd_hf}
\title{Calculates the geodesic distance between two points specified by latitude and longitude using the Haversine formula}
\usage{
gcd_hf(long1, lat1, long2, lat2)
}
\arguments{
\item{long1}{- Longitudinal value of first point in decimal degrees}

\item{lat1}{- Latitudinal value of first point in decimal degrees}

\item{long2}{- Longitudinal value of second point in decimal degrees}

\item{lat2}{- Latitudinal value of second point in decimal degrees}
}
\value{
Returns the distance between two points on the Earth in kilometers
}
\description{
Calculates the geodesic distance between two points specified by latitude and longitude using the Haversine formula
}
\details{
The Haversine formula can be inaccurate depending on coordinates
}
\note{
The haversine method is inaccuarate and should only be used when the vicenty formula fails or over very small distances
}
\examples{
long1<-22
lat1<-44
long2<-52
lat2<-51
gcd_hf(long1,lat1,long2,lat2)
}
\references{
[1] Adapted from http://www.r-bloggers.com/great-circle-distance-calculations-in-r/
}
