% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_invitro_concentration.R
\name{calc_invitro_concentration}
\alias{calc_invitro_concentration}
\title{Calculate \emph{in vitro} concentration}
\usage{
calc_invitro_concentration(D_int, C_ss = NULL)
}
\arguments{
\item{D_int}{internal chemical dose in \eqn{\frac{mg}{kg}}}

\item{C_ss}{steady-state plasma concentration in \eqn{\frac{\mu M}{mg / kg}}}
}
\value{
list of matrices containing concentrations in \eqn{\mu M}
}
\description{
Estimate the \emph{in vitro} equivalent plasma concentration given internal
chemical dose and steady-state plasma concentration.
}
\details{
Input \code{D_int} must be a matrix or list of matrices. Input \code{C_ss} must be a
numeric atomic vector or matrix, or a list of those types.

The \emph{in vitro} equivalent plasma concentration is calculated as:
\deqn{C_{plasma} = C_{ss} \times D_{int}}
}
\examples{
# Single population
D_int <- matrix(1:15, ncol = 3)
C_ss <- 1:5
calc_invitro_concentration(D_int, C_ss)

# Multiple populations
D_int <- list(
  "a" = matrix(1:15 / 10, ncol = 3),
  "b" = matrix(1:8, ncol = 2)
)
C_ss <- list(1:5, 1:4 / 2)
calc_invitro_concentration(D_int, C_ss)

}
