% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_exposure.R
\name{plot_exposure}
\alias{plot_exposure}
\title{Plot exposure data.}
\usage{
plot_exposure(
  exposure,
  region_boundary,
  group_boundary = NULL,
  chem_label = "chnm",
  ncol = 2
)
}
\arguments{
\item{exposure}{list of exposure data named by region label.}

\item{region_boundary}{"sf" data.frame mapping features to a "geometry"
column. Used to color regions.}

\item{group_boundary}{(optional) "sf" data.frame containing a "geometry"
column. Used to draw outlines.}

\item{chem_label}{label for facet_wrap.}

\item{ncol}{number of columns to wrap.}
}
\value{
ggplot2 object.
}
\description{
Plot exposure data.
}
\examples{
# Load package data
exposure <- split(geo_tox_data$exposure, ~FIPS)
region_boundary <- geo_tox_data$boundaries$county
group_boundary <- geo_tox_data$boundaries$state

# Plot county exposure data
# Use CASN as label to avoid long chemical names
plot_exposure(exposure,
              region_boundary,
              chem_label = "casn",
              ncol = 5)

# Add state boundaries
plot_exposure(exposure,
              region_boundary,
              group_boundary = group_boundary,
              chem_label = "casn",
              ncol = 5)
}
