% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_hill_params.R
\name{set_hill_params}
\alias{set_hill_params}
\title{Set Hill parameters for a GeoTox object.}
\usage{
set_hill_params(x, hill_params)
}
\arguments{
\item{x}{GeoTox object.}

\item{hill_params}{output of \link{fit_hill}.}
}
\value{
same GeoTox object with Hill parameters set.
}
\description{
Set Hill parameters for a GeoTox object.
}
\examples{
hill_params <- geo_tox_data$dose_response |>
  fit_hill(chem = "casn", assay = "endp") |>
  dplyr::filter(!tp.sd.imputed, !logAC50.sd.imputed)

geoTox <- GeoTox() |> 
  set_hill_params(hill_params)
}
