% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_sparse_cov_matrix.R
\name{generate_sparse_cov_matrix}
\alias{generate_sparse_cov_matrix}
\title{Generate Sparse Covariance Matrix}
\usage{
generate_sparse_cov_matrix(
  n,
  p,
  standardize = TRUE,
  sparse_rho = 0,
  scale_power = 0
)
}
\arguments{
\item{n}{The dimension of the covariance matrix (number of rows and columns).}

\item{p}{The rank of the covariance matrix (number of non-zero eigenvalues).
Must be less than or equal to \code{n}.}

\item{standardize}{Logical indicating whether to standardize the matrix,
setting this to TRUE overrides scale_power and sparse_rho.}

\item{sparse_rho}{Numeric threshold for enforcing sparsity.
Elements with absolute values below \code{sparse_rho} are set to zero.}

\item{scale_power}{The exponent used to scale the matrix elements.
Only used if \code{standardize} is \code{FALSE}.}
}
\value{
A \code{n} by \code{n} covariance matrix with rank \code{p}.
If \code{sparse_rho} is greater than zero and \code{standardize} is FALSE,
elements with absolute values below \code{sparse_rho} are set to zero to increase sparsity,
while ensuring that the matrix is at least semi-definite.
}
\description{
Generates a sparse covariance matrix with specified dimension and rank.
The generated matrix can be scaled or standardized, and further sparsified
based on a given threshold.
}
\examples{
# Generate a 10x10 sparse covariance matrix with rank 5
sparse_cov_matrix <- generate_sparse_cov_matrix(n = 10, p = 5)

# Generate a sparser matrix with elements below 0.3 set to zero
sparser_cov_matrix <- generate_sparse_cov_matrix(n = 100, p = 50,
                                                sparse_rho = 0.3,
                                              standardize = FALSE)

# Generate a standardized matrix
standardized_cov_matrix <- generate_sparse_cov_matrix(n = 100, p = 50, standardize = TRUE)

}
