% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.GKtauMatrix.R
\name{plot.GKtauMatrix}
\alias{plot.GKtauMatrix}
\title{Plot method for DataRobot S3 objects of class GKtauMatrix}
\usage{
\method{plot}{GKtauMatrix}(
  x,
  y,
  colorPlot = TRUE,
  corrColors = NULL,
  backgroundColor = "gray",
  diagColor = "black",
  diagSize = 1,
  ...
)
}
\arguments{
\item{x}{S3 object of class GKtauMatrix to be plotted.}

\item{y}{Not used; included for conformance with plot() generic
function parameter requirements.}

\item{colorPlot}{Logical variable indicating whether to
generate a color plot (the default, for colorPlot = TRUE)
or a black-and-white plot.}

\item{corrColors}{Character vector giving the color names
for the correlation values printed on the plot; default
value is NULL, causing rainbow(n) to be used, where n is
the number of rows and columns in the matrix x.}

\item{backgroundColor}{Character variable naming the background
color used for the correlation ellipses in the plot.}

\item{diagColor}{Character variable naming the color of the
text used to display the number of levels per variable along
the diagonal of the correlation matrix plot.}

\item{diagSize}{Numeric scale factor to adjust the text size for
the number of levels displayed on the diagonal of the plot array.}

\item{\dots}{Not used; included for conformance with plot() generic
function parameter requirements.}
}
\value{
None.  This function is called for its side-effect of
generating a plot.
}
\description{
Method for R's generic plot function for DataRobot S3 objects
of class GKtauMatrix.  This function generates an array of
Goodman-Kruskal tau association measures as described under
Details.  Note that, in general, this matrix is asymmetric.
}
\details{
This function calls the corrplot function from the corrplot
package to generate an array of correlation plots from the matrix
of Goodman-Kruskal tau measures returned by the GKtauDataframe
function.  The off-diagonal elements of this array contain
ellipses whose shape is determined by the corresponding tau
value, and the diagonal elements display the number of unique
levels for each variable in the plot.

This plot may be rendered either in color (the default, obtained
by specifying colorPlot as TRUE) or black-and-white.  In color
plots, the color of the text for the correlation values is set
by the corrColors parameter.  The default value for this parameter
is NULL, which causes the function to use the color vector
rainbow(n) where n is the number of rows and columns in the
GKtauMatrix object x.  The background color used to fill in
each ellipse is specified by bhe backgroundColor parameter,
and the text for the diagonal entries is determined by the
diagColor parameter.  In cases where the default choices make
the correlation values difficult to read, a useful alternative
is to specify corrColors = "blue".
}
\author{
Ron Pearson
}
