% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_published_time.R
\name{get_published_time}
\alias{get_published_time}
\title{Get Published Time from Goodreads}
\usage{
get_published_time(file_path)
}
\arguments{
\item{file_path}{A character string specifying the path to the file containing Goodreads book IDs.}
}
\value{
A named list where each element contains the book information for a book.
}
\description{
This function takes a file path containing Goodreads book IDs and retrieves
the published time for each book.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)
# Run the function
published_times <- get_published_time(temp_file)
print(published_times)
# Clean up: remove the temporary file
file.remove(temp_file)
}
}
