% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_vs_time_plot.R
\name{growth_vs_time_plot}
\alias{growth_vs_time_plot}
\title{Generate growth vs time plots}
\usage{
growth_vs_time_plot(
  growth_model_summary_list,
  plot_type = 2,
  growth_metric_name = "growth_metric",
  time_name = "time",
  cluster_name = "cluster",
  plot_title = "Growth vs Time",
  x_axis_breaks = ggplot2::waiver(),
  x_limits = c(NA, NA),
  n_x_axis_breaks = NULL,
  y_axis_breaks = ggplot2::waiver(),
  y_limits = c(NA, NA),
  n_y_axis_breaks = NULL,
  x_axis_text_size = 8,
  y_axis_text_size = 12,
  x_axis_title_size = 14,
  y_axis_title_size = 14,
  plot_title_size = 20,
  geom_point_size = 2,
  geom_line_width = 0.5,
  pred_plot_annotate_value = "double_time",
  annotate_value_text_size = 5
)
}
\arguments{
\item{growth_model_summary_list}{A list object created by the
\code{\link{growth_curve_model_fit}} function.}

\item{plot_type}{A numeric value used to specify the plot type to graph.
Values include 1, 2, 3, 4 with descriptions of each below (defaults to 2):
\itemize{
\item 1 - A scatterplot of the growth_metric vs time data where each
point is colored by cluster if applicable.
\item 2 - A scatterplot of the growth_metric vs time data where each
point is colored by cluster if applicable and the model predicted values
are overlayed as line.
When a mixed-effect model summary list is input, the predicted values
are the ind_fit_value which accounts for both fixed and random-effects.
When a least-squares model summary list is input the predicted values
are the fitted values accounting for fixed-effects only (pop_fit_value).
\item 3 - A scatterplot version of plot_type = 2 where each cluster is
separated into their own plot forming a matrix of growth_metric vs time
plots by cluster.
\item 4 - A plot of the estimates and prediction intervals of the model.
When a mixed-effects model summary list is input, the prediction
intervals are calculated from the median and the 2.5th and 97.5th
percentiles of the saemix model simulations to assist in showing the
variability of both the population trends and variation among the
cluster-level predictions (see \code{\link[saemix]{compute.sres}}).
When a least-squares model summary list is input, the prediction
intervals are calculated through Taylor-series approximations of the nls
model (see \code{\link[investr]{predFit}}).
By default will also add an annotation of the doubling time with 95\%
confidence intervals calculated directly from the original model estimates.
}}

\item{growth_metric_name}{A character string for specifying the name of
the growth metric (y-axis title) to be displayed on the plot.
Defaults to "growth_metric".}

\item{time_name}{A character string for specifying the name of the time
variable (x-axis title) to be displayed on the plot. Defaults to "time".}

\item{cluster_name}{A character string for specifying the name of the
cluster variable (legend title) to be displayed on the plot.
Defaults to "cluster".}

\item{plot_title}{A character string for specifying the title to be
displayed over the plot. Defaults to "Growth vs Time".}

\item{x_axis_breaks}{A numeric vector specifying manual numeric breaks.
Defaults to ggplot2::waiver(). See \code{\link[ggplot2]{scale_x_continuous}}.}

\item{x_limits}{A numeric vector of length two providing limits for
the x-axis. Use NA to refer to the existing minimum or maximum.
Defaults to c(NA, NA). See \code{\link[ggplot2]{scale_x_continuous}}.}

\item{n_x_axis_breaks}{An integer specifying the number of major breaks
for the x-axis. Defaults to NULL.
See \code{\link[ggplot2]{scale_x_continuous}}.}

\item{y_axis_breaks}{A numeric vector specifying manual numeric breaks.
Defaults to ggplot2::waiver(). See \code{\link[ggplot2]{scale_y_continuous}}.}

\item{y_limits}{A numeric vector of length two providing limits for
the y-axis. Use NA to refer to the existing minimum or maximum.
Defaults to c(NA, NA). See \code{\link[ggplot2]{scale_y_continuous}}.}

\item{n_y_axis_breaks}{An integer specifying the number of major breaks
for the x-axis. Defaults to NULL.
See \code{\link[ggplot2]{scale_y_continuous}}.}

\item{x_axis_text_size}{A numeric value specifying the size of the
x-axis text. Defaults to 8. See \code{\link[ggplot2]{element_text}}.}

\item{y_axis_text_size}{A numeric value specifying the size of the
y-axis text. Defaults to 12. See \code{\link[ggplot2]{element_text}}.}

\item{x_axis_title_size}{A numeric value specifying the size of the
x-axis title. Defaults to 14. See \code{\link[ggplot2]{element_text}}.}

\item{y_axis_title_size}{A numeric value specifying the size of the
y-axis title. Defaults to 14. See \code{\link[ggplot2]{element_text}}.}

\item{plot_title_size}{A numeric value specifying the size of the plot
title. Defaults to 20. See \code{\link[ggplot2]{element_text}}.}

\item{geom_point_size}{A numeric value specifying the size of the points
on the graph. Defaults to 2. See \code{\link[ggplot2]{geom_point}}.}

\item{geom_line_width}{A numeric value specifying the width of the line
(applicable only for plot_type = 2, 3, or 4). Defaults to 0.5.}

\item{pred_plot_annotate_value}{A character string specifying whether to add
the doubling time or rate estimates from the model to plot 4. Options
include "double_time" for the doubling time with 95\% CI, "rate" for the
rate estimate with 95\% CI, or "none" for no annotation. Defaults to
"double_time"}

\item{annotate_value_text_size}{A numeric value specifying the size of
the annotation text. Defaults to 5. See \code{\link[ggplot2]{geom_text}}.}
}
\value{
Returns a ggplot2 plot
}
\description{
This function provides a wrapper to ggplot2 in order to generate
different plots from a growth curve model summary list object generated by
the \code{\link{growth_curve_model_fit}} function.
Please refer to the documentation for the 'plot_type' parameter for the
different plot options.
}
\examples{
\donttest{
# Load example data (exponential data)
data(exp_mixed_data)
# Fit an mixed-effects growth model to the data
exp_mixed_model_summary <- growth_curve_model_fit(
  data_frame = exp_mixed_data,
  function_type = "exponential",
  verbose = FALSE
)
# Create growth vs time plot of data with fitted values (plot_type = 2)
exp_growth_plot <- growth_vs_time_plot(
  growth_model_summary_list = exp_mixed_model_summary,
  plot_type = 2
)
print(exp_growth_plot)
}
}
\seealso{
\code{\link{growth_curve_model_fit}}
}
