% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_harx.R
\name{load_harx}
\alias{load_harx}
\title{Load and Process HAR Files with Header Selection}
\usage{
load_harx(
  file_path,
  coefAsname = FALSE,
  lowercase = FALSE,
  select_header = NULL
)
}
\arguments{
\item{file_path}{Character. The file path to the HAR file.}

\item{coefAsname}{Logical. If \code{TRUE}, replaces four-letter headers with coefficient names when available. Default is \code{FALSE}.}

\item{lowercase}{Logical. If \code{TRUE}, converts all variable names to lowercase. Default is \code{FALSE}.}

\item{select_header}{Character vector. Specific headers to read; if \code{NULL}, all headers are read. Example: \code{select_header = c("A", "E1")}.}
}
\value{
A structured list containing:
\itemize{
\item \code{data}: Extracted HAR variable data stored as matrices, arrays, or vectors.
\item \code{dimension_info}: A list with:
\itemize{
\item \code{dimension_string}: A textual representation of dimensions (e.g., "REG\emph{COMM}YEAR").
\item \code{dimension_names}: The names of each dimension.
\item \code{dimension_sizes}: The size of each dimension.
}
}
}
\description{
Reads a GEMPACK HAR file and extracts structured data while maintaining compatibility
with standard HAR formats. Provides flexibility in naming conventions and header selection.
}
\details{
\itemize{
\item Uses \code{load_harplus()} internally for efficient HAR file reading.
\item Allows optional conversion of variable names to lowercase (\code{lowercase = TRUE}).
\item Supports coefficient-based naming (\code{coefAsname = TRUE}).
\item Enables selective header extraction via \code{select_header = c("A", "E1")}.
\item Returns structured data with explicit dimension names and sizes.
}
}
\examples{
# Path to example files
har_path <- system.file("extdata", "TAR10-WEL.har", package = "HARplus")

# Basic loading
har_data <- load_harx(har_path)

# Load with coefficient names
har_data_coef <- load_harx(har_path, coefAsname = TRUE)

# Load with lowercase names
har_data_lower <- load_harx(har_path, lowercase = TRUE)

# Load specific headers
har_selected <- load_harx(har_path, select_header = c("A", "E1"))

# Load with multiple options
har_combined <- load_harx(har_path,
                         coefAsname = TRUE,
                         lowercase = TRUE,
                         select_header = c("A", "E1"))

}
\seealso{
\code{\link{load_sl4x}}, \code{\link{get_data_by_var}}, \code{\link{get_data_by_dims}}
}
\author{
Pattawee Puangchit
}
